package automobile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

/**
 * Premier garage, affichant les véhicules qu'il contient
 * Utilise des ArrayList
 * Container de Véhicules
 * Implémente un itérateur Iterable
 * @author Adrien Poupa
 */
public class Garage1 implements Iterable<Vehicule> {

    // Pour l'instant on utilise des ArrayList
    ArrayList<Vehicule> list;

    /**
     * Constructeur par défaut de Garage1
     * Instancie l'ArrayList
     */
    public Garage1() {
        list = new ArrayList<Vehicule>();
    }

    /**
     * Ajout d'un véhicule au garage
     * Rien de particulier ici, on utilise la méthode native d'ArrayList
     * @param voiture objet Vehicule à ajouter
     */
    public void add(Vehicule voiture) {
        list.add(voiture);
    }

    /**
     * Itérateur de Garage1, contenant des Véhicules
     * Retourne une nouvelle instance de l'itérateur de garage1 prenant en paramètre l'ArrayList de voiture
     * @return objet iterator contenant les Céhicules
     */
    public Iterator<Vehicule> iterator() {
        return new IteratorGarage(list);
    }

    /**
     * Permet de faire le plein de tous les véhicules en faisant une boucle for, rendue possible par l'itérateur
     * On ne fait le plein que s'il reste moins de 10L dans le réservoir
     * Ce n'est pas *encore* l'implémentation mapping, celle-ci sera faite plus tard
     */
    public void faireLePleinAll() {
        for(Vehicule vehicule : list) {
            if (vehicule.getJauge() < 10) {
                vehicule.faireLePlein();
            }
        }
    }

    /**
     * Permet de réinitialiser tous les compteurs partiels des Véhicules du garage
     * Ce n'est pas *encore* l'implémentation mapping, celle-ci sera faite plus tard
     */
    public void resetPartielAll() {
        for(Vehicule vehicule : list) {
            vehicule.getCompteur().resetPartiel();
        }
    }

    /**
     * Surcharge de toString, affiche les Véhicules contenus dans le garage
     * @return liste du type "Vehicule X : compteur = [Totalisateur = X | Partiel = X]; jauge = X"
     */
    @Override
    public String toString() {
        StringBuilder returnString = new StringBuilder();

        for(Vehicule vehicule : list) {
            returnString.append(vehicule.toString());
            returnString.append(System.getProperty("line.separator")); // Retour à la ligne
        }

        return returnString.toString();
    }

    /**
     * Tri des voitures par numéro d'immatriculation
     * J'ai laissé Immatriculion tel qu'implémenté dans la classe de tests...
     * On utilise d'abord Collections, prenant la liste des véhicules actuellement dans le garage
     * et en utilisant une méthode de tri présente dans la nouvelle classe GarageTriImmatriculion (même typo)
     */
    public void triNoImmatriculion() {
        Collections.sort(list, new GarageTriImmatriculion());
    }

    /**
     * Tri des voitures par compteur
     * On utilise d'abord Collections, prenant la liste des véhicules actuellement dans le garage
     * et en utilisant une méthode de tri présente dans la nouvelle classe CompteurComparator
     */
    public void triCompteur() {
        Collections.sort(list, new CompteurComparator());
    }
}
